/*
 * LG Optimus Black (P970) codename sniper board
 *
 * Copyright (C) 2015 Paul Kocialkowski <contact@paulk.fr>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _SNIPER_H_
#define _SNIPER_H_

#include <asm/arch/mux.h>

#define MUX_SNIPER() \
	/* SDRC */ \
	MUX_VAL(CP(SDRC_D0),		(IEN  | PTD | DIS | M0)) /* SDRC_D0 */\
	MUX_VAL(CP(SDRC_D1),		(IEN  | PTD | DIS | M0)) /* SDRC_D1 */\
	MUX_VAL(CP(SDRC_D2),		(IEN  | PTD | DIS | M0)) /* SDRC_D2 */\
	MUX_VAL(CP(SDRC_D3),		(IEN  | PTD | DIS | M0)) /* SDRC_D3 */\
	MUX_VAL(CP(SDRC_D4),		(IEN  | PTD | DIS | M0)) /* SDRC_D4 */\
	MUX_VAL(CP(SDRC_D5),		(IEN  | PTD | DIS | M0)) /* SDRC_D5 */\
	MUX_VAL(CP(SDRC_D6),		(IEN  | PTD | DIS | M0)) /* SDRC_D6 */\
	MUX_VAL(CP(SDRC_D7),		(IEN  | PTD | DIS | M0)) /* SDRC_D7 */\
	MUX_VAL(CP(SDRC_D8),		(IEN  | PTD | DIS | M0)) /* SDRC_D8 */\
	MUX_VAL(CP(SDRC_D9),		(IEN  | PTD | DIS | M0)) /* SDRC_D9 */\
	MUX_VAL(CP(SDRC_D10),		(IEN  | PTD | DIS | M0)) /* SDRC_D10 */\
	MUX_VAL(CP(SDRC_D11),		(IEN  | PTD | DIS | M0)) /* SDRC_D11 */\
	MUX_VAL(CP(SDRC_D12),		(IEN  | PTD | DIS | M0)) /* SDRC_D12 */\
	MUX_VAL(CP(SDRC_D13),		(IEN  | PTD | DIS | M0)) /* SDRC_D13 */\
	MUX_VAL(CP(SDRC_D14),		(IEN  | PTD | DIS | M0)) /* SDRC_D14 */\
	MUX_VAL(CP(SDRC_D15),		(IEN  | PTD | DIS | M0)) /* SDRC_D15 */\
	MUX_VAL(CP(SDRC_D16),		(IEN  | PTD | DIS | M0)) /* SDRC_D16 */\
	MUX_VAL(CP(SDRC_D17),		(IEN  | PTD | DIS | M0)) /* SDRC_D17 */\
	MUX_VAL(CP(SDRC_D18),		(IEN  | PTD | DIS | M0)) /* SDRC_D18 */\
	MUX_VAL(CP(SDRC_D19),		(IEN  | PTD | DIS | M0)) /* SDRC_D19 */\
	MUX_VAL(CP(SDRC_D20),		(IEN  | PTD | DIS | M0)) /* SDRC_D20 */\
	MUX_VAL(CP(SDRC_D21),		(IEN  | PTD | DIS | M0)) /* SDRC_D21 */\
	MUX_VAL(CP(SDRC_D22),		(IEN  | PTD | DIS | M0)) /* SDRC_D22 */\
	MUX_VAL(CP(SDRC_D23),		(IEN  | PTD | DIS | M0)) /* SDRC_D23 */\
	MUX_VAL(CP(SDRC_D24),		(IEN  | PTD | DIS | M0)) /* SDRC_D24 */\
	MUX_VAL(CP(SDRC_D25),		(IEN  | PTD | DIS | M0)) /* SDRC_D25 */\
	MUX_VAL(CP(SDRC_D26),		(IEN  | PTD | DIS | M0)) /* SDRC_D26 */\
	MUX_VAL(CP(SDRC_D27),		(IEN  | PTD | DIS | M0)) /* SDRC_D27 */\
	MUX_VAL(CP(SDRC_D28),		(IEN  | PTD | DIS | M0)) /* SDRC_D28 */\
	MUX_VAL(CP(SDRC_D29),		(IEN  | PTD | DIS | M0)) /* SDRC_D29 */\
	MUX_VAL(CP(SDRC_D30),		(IEN  | PTD | DIS | M0)) /* SDRC_D30 */\
	MUX_VAL(CP(SDRC_D31),		(IEN  | PTD | DIS | M0)) /* SDRC_D31 */\
	MUX_VAL(CP(SDRC_CLK),		(IEN  | PTD | DIS | M0)) /* SDRC_CLK */\
	MUX_VAL(CP(SDRC_DQS0),		(IEN  | PTD | DIS | M0)) /* SDRC_DQS0 */\
	MUX_VAL(CP(SDRC_DQS1),		(IEN  | PTD | DIS | M0)) /* SDRC_DQS1 */\
	MUX_VAL(CP(SDRC_DQS2),		(IEN  | PTD | DIS | M0)) /* SDRC_DQS2 */\
	MUX_VAL(CP(SDRC_DQS3),		(IEN  | PTD | DIS | M0)) /* SDRC_DQS3 */ \
	/* GPMC */ \
	MUX_VAL(CP(GPMC_A1),		(IDIS | PTU | DIS | M4)) /* GPIO_34: LCD_RESET_N */ \
	MUX_VAL(CP(GPMC_A2),		(IEN  | PTU | DIS | M4)) /* GPIO_35: TOUCH_INT_N */ \
	MUX_VAL(CP(GPMC_A3),		(IDIS | PTU | DIS | M4)) /* GPIO_36: VT_CAM_PWDN */ \
	MUX_VAL(CP(GPMC_A4),		(IDIS | PTU | DIS | M4)) /* GPIO_37: CAM_SUBPM_EN */\
	MUX_VAL(CP(GPMC_A5),		(IEN  | PTD | DIS | M4)) /* GPIO_38: MODEM_PWR_CHK */\
	MUX_VAL(CP(GPMC_A6),		(IDIS | PTD | DIS | M4)) /* GPIO_39: MODEM_WAKE */\
	MUX_VAL(CP(GPMC_A7),		(IEN  | PTU | DIS | M4)) /* GPIO_40: MUIC_INT_N */\
	MUX_VAL(CP(GPMC_A8),		(IEN  | PTD | DIS | M4)) /* GPIO_41: GYRO_INT_N */\
	MUX_VAL(CP(GPMC_A9),		(IEN  | PTD | EN  | M4)) /* GPIO_42: MOTION_INT_N */\
	MUX_VAL(CP(GPMC_A10),		(IEN  | PTD | DIS | M4)) /* GPIO_43: BT_HOST_WAKEUP */\
	MUX_VAL(CP(GPMC_D0),		(IEN  | PTD | DIS | M0)) /* GPMC_D0 */ \
	MUX_VAL(CP(GPMC_D1),		(IEN  | PTD | DIS | M0)) /* GPMC_D1 */ \
	MUX_VAL(CP(GPMC_D2),		(IEN  | PTD | DIS | M0)) /* GPMC_D2 */ \
	MUX_VAL(CP(GPMC_D3),		(IEN  | PTD | DIS | M0)) /* GPMC_D3 */ \
	MUX_VAL(CP(GPMC_D4),		(IEN  | PTD | DIS | M0)) /* GPMC_D4 */ \
	MUX_VAL(CP(GPMC_D5),		(IEN  | PTD | DIS | M0)) /* GPMC_D5 */ \
	MUX_VAL(CP(GPMC_D6),		(IEN  | PTD | DIS | M0)) /* GPMC_D6 */ \
	MUX_VAL(CP(GPMC_D7),		(IEN  | PTD | DIS | M0)) /* GPMC_D7 */ \
	MUX_VAL(CP(GPMC_D8),		(IEN  | PTD | DIS | M0)) /* GPMC_D8 */ \
	MUX_VAL(CP(GPMC_D9),		(IEN  | PTD | DIS | M0)) /* GPMC_D9 */ \
	MUX_VAL(CP(GPMC_D10),		(IEN  | PTD | DIS | M0)) /* GPMC_D10 */ \
	MUX_VAL(CP(GPMC_D11),		(IEN  | PTD | DIS | M0)) /* GPMC_D11 */ \
	MUX_VAL(CP(GPMC_D12),		(IEN  | PTD | DIS | M0)) /* GPMC_D12 */ \
	MUX_VAL(CP(GPMC_D13),		(IEN  | PTD | DIS | M0)) /* GPMC_D13 */ \
	MUX_VAL(CP(GPMC_D14),		(IEN  | PTD | DIS | M0)) /* GPMC_D14 */ \
	MUX_VAL(CP(GPMC_NCS0),		(IDIS | PTD | DIS | M7)) \
	MUX_VAL(CP(GPMC_NCS1),		(IDIS | PTD | DIS | M4)) /* GPIO_52: BT_WAKE_UP */ \
	MUX_VAL(CP(GPMC_NCS2),		(IEN  | PTD | DIS | M4)) /* GPIO_53: LCD_TE */ \
	MUX_VAL(CP(GPMC_NCS3),		(IDIS | PTD | DIS | M4)) /* GPIO_54: LCD_CS */ \
	MUX_VAL(CP(GPMC_NCS4),		(IDIS | PTD | DIS | M4)) /* GPIO_55: BT_MAKER_ID */ \
	MUX_VAL(CP(GPMC_NCS5),		(IDIS | PTD | DIS | M3)) /* GPIO_56: VIBE_PWM */ \
	MUX_VAL(CP(GPMC_NCS6),		(IDIS | PTD | DIS | M4)) /* GPIO_57: VIBE_EN */ \
	MUX_VAL(CP(GPMC_NCS7),		(IEN  | PTD | DIS | M4)) /* GPIO_58: COM_INT */ \
	MUX_VAL(CP(GPMC_CLK),		(IDIS | PTD | DIS | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(GPMC_NADV_ALE),	(IDIS | PTD | DIS | M7)) \
	MUX_VAL(CP(GPMC_NOE),		(IDIS | PTD | DIS | M7)) \
	MUX_VAL(CP(GPMC_NWE),		(IDIS | PTD | DIS | M7)) \
	MUX_VAL(CP(GPMC_NBE0_CLE),	(IDIS | PTD | DIS | M4)) /* GPIO_60: PROXI_LDO_EN */ \
	MUX_VAL(CP(GPMC_NBE1),		(IDIS | PTD | DIS | M4)) /* GPIO_61: VT_RESET_N */ \
	MUX_VAL(CP(GPMC_NWP),		(IDIS | PTD | DIS | M4)) /* GPIO_62: LCD_CP_EN */ \
	MUX_VAL(CP(GPMC_WAIT0),		(IEN  | PTU | EN  | M4)) \
	MUX_VAL(CP(GPMC_WAIT1),		(IEN  | PTD | DIS | M4)) /* GPIO_63: ONENAND_INT */ \
	MUX_VAL(CP(GPMC_WAIT2),		(IDIS | PTD | DIS | M2)) /* GPIO_64: UART4_TX_IPC */ \
	MUX_VAL(CP(GPMC_WAIT3),		(IEN  | PTD | DIS | M2)) /* GPIO_65: UART4_RX_IPC */ \
	/* DSS */ \
	MUX_VAL(CP(DSS_PCLK),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_HSYNC),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_VSYNC),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_ACBIAS),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA0),		(IDIS | PTD | DIS | M1)) /* DSI_DX0 */ \
	MUX_VAL(CP(DSS_DATA1),		(IDIS | PTD | DIS | M1)) /* DSI_DY0 */ \
	MUX_VAL(CP(DSS_DATA2),		(IDIS | PTD | DIS | M1)) /* DSI_DX1 */ \
	MUX_VAL(CP(DSS_DATA3),		(IDIS | PTD | DIS | M1)) /* DSI_DY1 */ \
	MUX_VAL(CP(DSS_DATA4),		(IDIS | PTD | DIS | M1)) /* DSI_DX2 */ \
	MUX_VAL(CP(DSS_DATA5),		(IDIS | PTD | DIS | M1)) /* DSI_DY2 */ \
	MUX_VAL(CP(DSS_DATA6),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA7),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA8),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA9),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA10),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA11),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA12),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA13),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA14),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA15),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA16),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA17),		(IDIS | PTD | DIS | M4)) /* GPIO_87: MIC_SEL */ \
	MUX_VAL(CP(DSS_DATA18),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA19),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA20),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA21),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA22),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(DSS_DATA23),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	/* CAM */ \
	MUX_VAL(CP(CAM_HS),		(IEN  | PTD | EN  | M0)) /* CAM_HS */ \
	MUX_VAL(CP(CAM_VS),		(IEN  | PTD | EN  | M0)) /* CAM_VS */ \
	MUX_VAL(CP(CAM_XCLKA),		(IDIS | PTD | DIS | M0)) /* CAM_XCLKA */ \
	MUX_VAL(CP(CAM_PCLK),		(IEN  | PTD | EN  | M0)) /* CAM_PCLK */ \
	MUX_VAL(CP(CAM_FLD),		(IDIS | PTU | DIS | M4)) /* GPIO_98: 5M_RESET_N */ \
	MUX_VAL(CP(CAM_D0),		(IEN  | PTD | DIS | M2)) /* CSI2_DX2 */ \
	MUX_VAL(CP(CAM_D1),		(IEN  | PTD | DIS | M2)) /* CSI2_DY2 */ \
	MUX_VAL(CP(CAM_D2),		(IDIS | PTD | EN  | M4)) /* GPIO_101: IFX_USB_VBUS_EN */ \
	MUX_VAL(CP(CAM_D3),		(IDIS | PTD | DIS | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(CAM_D4),		(IEN  | PTD | DIS | M0)) /* CAM_D4 */ \
	MUX_VAL(CP(CAM_D5),		(IEN  | PTD | DIS | M0)) /* CAM_D5 */ \
	MUX_VAL(CP(CAM_D6),		(IEN  | PTD | DIS | M0)) /* CAM_D6 */ \
	MUX_VAL(CP(CAM_D7),		(IEN  | PTD | DIS | M0)) /* CAM_D7 */ \
	MUX_VAL(CP(CAM_D8),		(IEN  | PTD | DIS | M0)) /* CAM_D8 */ \
	MUX_VAL(CP(CAM_D9),		(IEN  | PTD | DIS | M0)) /* CAM_D9 */ \
	MUX_VAL(CP(CAM_D10),		(IEN  | PTD | DIS | M0)) /* CAM_D10 */ \
	MUX_VAL(CP(CAM_D11),		(IEN  | PTD | DIS | M0)) /* CAM_D11 */ \
	MUX_VAL(CP(CAM_XCLKB),		(IEN  | PTD | DIS | M0)) /* CAM_XCLKB */ \
	MUX_VAL(CP(CAM_WEN),		(IDIS | PTD | DIS | M4)) /* GPIO_167: 5M_CAM_VCN_EN */ \
	MUX_VAL(CP(CAM_STROBE),		(IEN  | PTD | DIS | M7)) /* SAFE_MODE */ \
	/* CSI2 */ \
	MUX_VAL(CP(CSI2_DX0),		(IEN  | PTD | DIS | M0)) /* CSI2_DX0 */ \
	MUX_VAL(CP(CSI2_DY0),		(IEN  | PTD | DIS | M0)) /* CSI2_DY0 */ \
	MUX_VAL(CP(CSI2_DX1),		(IEN  | PTD | DIS | M0)) /* CSI2_DX1 */ \
	MUX_VAL(CP(CSI2_DY1),		(IEN  | PTD | DIS | M0)) /* CSI2_DY1 */ \
	/* MCBSP2 */ \
	MUX_VAL(CP(MCBSP2_FSX),		(IEN  | PTD | DIS | M0)) /* MCBSP2_FSX */ \
	MUX_VAL(CP(MCBSP2_CLKX),	(IEN  | PTD | DIS | M0)) /* MCBSP2_CLKX */ \
	MUX_VAL(CP(MCBSP2_DR),		(IEN  | PTD | DIS | M0)) /* MCBSP2_DR */ \
	MUX_VAL(CP(MCBSP2_DX),		(IDIS | PTD | DIS | M0)) /* MCBSP2_DX */ \
	/* MMC1 */ \
	MUX_VAL(CP(MMC1_CLK),		(IDIS | PTD | DIS | M0)) /* MMC1_CLK */ \
	MUX_VAL(CP(MMC1_CMD),		(IEN  | PTU | DIS | M0)) /* MMC1_CMD */ \
	MUX_VAL(CP(MMC1_DAT0),		(IEN  | PTU | DIS | M0)) /* MMC1_DAT0 */ \
	MUX_VAL(CP(MMC1_DAT1),		(IEN  | PTU | DIS | M0)) /* MMC1_DAT1 */ \
	MUX_VAL(CP(MMC1_DAT2),		(IEN  | PTU | DIS | M0)) /* MMC1_DAT2 */ \
	MUX_VAL(CP(MMC1_DAT3),		(IEN  | PTU | DIS | M0)) /* MMC1_DAT3 */ \
	MUX_VAL(CP(MMC1_DAT4),		(IEN  | PTD | DIS | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(MMC1_DAT5),		(IEN  | PTD | DIS | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(MMC1_DAT6),		(IEN  | PTD | DIS | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(MMC1_DAT7),		(IEN  | PTD | DIS | M7)) /* SAFE_MODE */ \
	/* MMC2 */ \
	MUX_VAL(CP(MMC2_CLK),		(IEN  | PTD | DIS | M0)) /* MMC2_CLK */ \
	MUX_VAL(CP(MMC2_CMD),		(IEN  | PTD | DIS | M0)) /* MMC2_CMD */ \
	MUX_VAL(CP(MMC2_DAT0),		(IEN  | PTD | DIS | M0)) /* MMC2_DAT0 */ \
	MUX_VAL(CP(MMC2_DAT1),		(IEN  | PTD | DIS | M0)) /* MMC2_DAT1 */ \
	MUX_VAL(CP(MMC2_DAT2),		(IEN  | PTD | DIS | M0)) /* MMC2_DAT2 */ \
	MUX_VAL(CP(MMC2_DAT3),		(IEN  | PTD | DIS | M0)) /* MMC2_DAT3 */ \
	MUX_VAL(CP(MMC2_DAT4),		(IEN  | PTD | DIS | M0)) /* MMC2_DAT4 */ \
	MUX_VAL(CP(MMC2_DAT5),		(IEN  | PTD | DIS | M0)) /* MMC2_DAT5 */ \
	MUX_VAL(CP(MMC2_DAT6),		(IEN  | PTD | DIS | M0)) /* MMC2_DAT6 */ \
	MUX_VAL(CP(MMC2_DAT7),		(IEN  | PTD | DIS | M0)) /* MMC2_DAT7 */ \
	/* MCBSP3 */ \
	MUX_VAL(CP(MCBSP3_DX),		(IDIS | PTD | DIS | M0)) /* MCBSP3_DX */ \
	MUX_VAL(CP(MCBSP3_DR),		(IEN  | PTD | DIS | M0)) /* MCBSP3_DR */ \
	MUX_VAL(CP(MCBSP3_CLKX),	(IEN  | PTD | DIS | M0)) /* MCBSP3_CLKX */ \
	MUX_VAL(CP(MCBSP3_FSX),		(IEN  | PTD | DIS | M0)) /* MCBSP3_FSX */ \
	/* UART2 */ \
	MUX_VAL(CP(UART2_CTS),		(IEN  | PTU | DIS | M0)) /* UART2_CTS */ \
	MUX_VAL(CP(UART2_RTS),		(IDIS | PTU | DIS | M0)) /* UART2_RTS */ \
	MUX_VAL(CP(UART2_TX),		(IDIS | PTD | DIS | M0)) /* UART2_TX */ \
	MUX_VAL(CP(UART2_RX),		(IEN  | PTD | DIS | M0)) /* UART2_RX */ \
	/* UART1 */ \
	MUX_VAL(CP(UART1_TX),		(IDIS | PTU | DIS | M0)) /* UART1_TX */ \
	MUX_VAL(CP(UART1_RTS),		(IDIS | PTU | DIS | M0)) /* UART1_RTS */ \
	MUX_VAL(CP(UART1_CTS),		(IEN  | PTU | DIS | M0)) /* UART1_CTS */ \
	MUX_VAL(CP(UART1_RX),		(IEN  | PTU | DIS | M0)) /* UART1_RX */ \
	/* MCBSP4 */ \
	MUX_VAL(CP(MCBSP4_CLKX),	(IDIS | PTD | DIS | M4)) /* GPIO_152: GPS_PWR_ON */ \
	MUX_VAL(CP(MCBSP4_DR),		(IDIS | PTD | DIS | M4)) /* GPIO_153: GPS_RESET_N */ \
	MUX_VAL(CP(MCBSP4_DX),		(IDIS | PTD | DIS | M4)) /* GPIO_154: FLASH_LED_TORCH */ \
	MUX_VAL(CP(MCBSP4_FSX),		(IDIS | PTD | DIS | M4)) /* GPIO_155: FLASH_LED_EN */ \
	/* MCBSP1 */ \
	MUX_VAL(CP(MCBSP1_CLKR),	(IEN  | PTD | DIS | M0)) /* MCBSP1_CLKR */ \
	MUX_VAL(CP(MCBSP1_FSR),		(IEN  | PTD | DIS | M0)) /* MCBSP1_FSR */ \
	MUX_VAL(CP(MCBSP1_DX),		(IDIS | PTD | DIS | M0)) /* MCBSP1_DX */ \
	MUX_VAL(CP(MCBSP1_DR),		(IEN  | PTD | DIS | M0)) /* MCBSP1_DR */ \
	MUX_VAL(CP(MCBSP_CLKS),		(IDIS | PTD | DIS | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(MCBSP1_FSX),		(IDIS | PTD | DIS | M4)) /* GPIO_161: OMAP_UART_SW */ \
	MUX_VAL(CP(MCBSP1_CLKX),	(IDIS | PTD | DIS | M4)) /* GPIO_162: IFX_UART_SW */ \
	/* UART3 */ \
	MUX_VAL(CP(UART3_CTS_RCTX),	(IEN  | PTD | EN  | M4)) /* GPIO_163: HOOK_DIG */ \
	MUX_VAL(CP(UART3_RTS_SD),	(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(UART3_RX_IRRX),	(IEN  | PTD | DIS | M0)) /* UART3_RX_IRRX */ \
	MUX_VAL(CP(UART3_TX_IRTX),	(IDIS | PTD | DIS | M0)) /* UART3_TX_IRTX */ \
	/* HSUSB0 */ \
	MUX_VAL(CP(HSUSB0_CLK),		(IEN  | PTD | EN  | M0)) /* HSUSB0_CLK */\
	MUX_VAL(CP(HSUSB0_STP),		(IDIS | PTD | DIS | M0)) /* HSUSB0_STP */\
	MUX_VAL(CP(HSUSB0_DIR),		(IEN  | PTD | EN  | M0)) /* HSUSB0_DIR */\
	MUX_VAL(CP(HSUSB0_NXT),		(IEN  | PTD | EN  | M0)) /* HSUSB0_NXT */\
	MUX_VAL(CP(HSUSB0_DATA0),	(IEN  | PTD | EN  | M0)) /* HSUSB0_DATA0 */\
	MUX_VAL(CP(HSUSB0_DATA1),	(IEN  | PTD | EN  | M0)) /* HSUSB0_DATA1 */\
	MUX_VAL(CP(HSUSB0_DATA2),	(IEN  | PTD | EN  | M0)) /* HSUSB0_DATA2 */\
	MUX_VAL(CP(HSUSB0_DATA3),	(IEN  | PTD | EN  | M0)) /* HSUSB0_DATA3 */\
	MUX_VAL(CP(HSUSB0_DATA4),	(IEN  | PTD | EN  | M0)) /* HSUSB0_DATA4 */\
	MUX_VAL(CP(HSUSB0_DATA5),	(IEN  | PTD | EN  | M0)) /* HSUSB0_DATA5 */\
	MUX_VAL(CP(HSUSB0_DATA6),	(IEN  | PTD | EN  | M0)) /* HSUSB0_DATA6 */\
	MUX_VAL(CP(HSUSB0_DATA7),	(IEN  | PTD | EN  | M0)) /* HSUSB0_DATA7 */ \
	/* I2C1 */ \
	MUX_VAL(CP(I2C1_SCL),		(IEN  | PTU | EN  | M0)) /* I2C1_SCL */ \
	MUX_VAL(CP(I2C1_SDA),		(IEN  | PTU | EN  | M0)) /* I2C1_SDA */ \
	/* I2C2 */ \
	MUX_VAL(CP(I2C2_SCL),		(IEN  | PTU | DIS | M0)) /* I2C2_SCL */ \
	MUX_VAL(CP(I2C2_SDA),		(IEN  | PTU | DIS | M0)) /* I2C2_SDA */ \
	/* I2C3 */ \
	MUX_VAL(CP(I2C3_SCL),		(IEN  | PTU | DIS | M0)) /* I2C3_SCL */ \
	MUX_VAL(CP(I2C3_SDA),		(IEN  | PTU | DIS | M0)) /* I2C3_SDA */ \
	/* I2C4 */ \
	MUX_VAL(CP(I2C4_SCL),		(IEN  | PTU | EN  | M0)) /* I2C4_SCL */ \
	MUX_VAL(CP(I2C4_SDA),		(IEN  | PTU | EN  | M0)) /* I2C4_SDA */ \
	/* HDQ */ \
	MUX_VAL(CP(HDQ_SIO),		(IEN  | PTD | EN  | M4)) /* GPIO_170: EAR_SENSE */ \
	/* MCSPI1 */ \
	MUX_VAL(CP(MCSPI1_CLK),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(MCSPI1_SIMO),	(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(MCSPI1_SOMI),	(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(MCSPI1_CS0),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(MCSPI1_CS1),		(IEN  | PTU | DIS | M4)) /* GPIO_175: GAUGE_INT  */ \
	MUX_VAL(CP(MCSPI1_CS2),		(IEN  | PTU | DIS | M4)) /* GPIO_176: MODEM_SEND */ \
	MUX_VAL(CP(MCSPI1_CS3),		(IDIS | PTU | DIS | M4)) /* GPIO_177: MODEM_CHK */ \
	MUX_VAL(CP(MCSPI2_CLK),		(IEN  | PTD | EN  | M0)) /* MCSPI2_CLK */ \
	MUX_VAL(CP(MCSPI2_SIMO),	(IDIS | PTD | DIS | M0)) /* MCSPI2_SIMO */ \
	MUX_VAL(CP(MCSPI2_SOMI),	(IEN  | PTD | DIS | M0)) /* MCSPI2_SOMI */ \
	MUX_VAL(CP(MCSPI2_CS0),		(IDIS | PTU | DIS | M4)) /* GPIO_181: WLAN_WAKEUP */ \
	MUX_VAL(CP(MCSPI2_CS1),		(IDIS | PTD | DIS | M4)) /* GPIO_182: USIF1_SW */ \
	/* SYS */ \
	MUX_VAL(CP(SYS_32K),		(IEN  | PTD | DIS | M0)) /* SYS_32K */ \
	MUX_VAL(CP(SYS_CLKREQ),		(IEN  | PTD | DIS | M0)) /* SYS_CLKREQ */ \
	MUX_VAL(CP(SYS_NIRQ),		(IEN  | PTU | EN  | M0)) /* SYS_NIRQ */ \
	MUX_VAL(CP(SYS_BOOT0),		(IEN  | PTU | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(SYS_BOOT1),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(SYS_BOOT2),		(IEN  | PTU | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(SYS_BOOT3),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(SYS_BOOT4),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(SYS_BOOT5),		(IEN  | PTD | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(SYS_BOOT6),		(IEN  | PTU | EN  | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(SYS_OFF_MODE),	(IDIS | PTD | DIS | M0)) /* SYS_OFF_MODE */ \
	MUX_VAL(CP(SYS_CLKOUT1),	(IEN  | PTU | DIS | M4)) /* GPIO_10: MICROSD_DET_N */ \
	MUX_VAL(CP(SYS_CLKOUT2),	(IDIS | PTD | EN  | M7)) /* SAFE_MODE */ \
	/* JTAG */ \
	MUX_VAL(CP(JTAG_NTRST),		(IEN  | PTD | DIS | M0)) /* JTAG_NTRST */ \
	MUX_VAL(CP(JTAG_TCK),		(IEN  | PTD | DIS | M0)) /* JTAG_TCK */ \
	MUX_VAL(CP(JTAG_TMS),		(IEN  | PTU | EN  | M0)) /* JTAG_TMS */ \
	MUX_VAL(CP(JTAG_TDI),		(IEN  | PTU | EN  | M0)) /* JTAG_TDI */ \
	MUX_VAL(CP(JTAG_EMU0),		(IEN  | PTU | DIS | M0)) /* JTAG_EMU0 */ \
	MUX_VAL(CP(JTAG_EMU1),		(IEN  | PTU | DIS | M0)) /* JTAG_EMU1 */ \
	/* ETK */ \
	MUX_VAL(CP(ETK_CLK_ES2),	(IEN  | PTD | DIS | M2)) /* SDMMC3_CLK */ \
	MUX_VAL(CP(ETK_CTL_ES2),	(IEN  | PTU | EN  | M2)) /* SDMMC3_CMD */ \
	MUX_VAL(CP(ETK_D0_ES2),		(IEN  | PTD | EN  | M4)) /* GPIO_14: PROX_OUT */ \
	MUX_VAL(CP(ETK_D1_ES2),		(IEN  | PTU | DIS | M4)) /* GPIO_15: CHG_STATUS_N_OMAP */ \
	MUX_VAL(CP(ETK_D2_ES2),		(IEN  | PTD | DIS | M4)) /* GPIO_16: BT_EN */ \
	MUX_VAL(CP(ETK_D3_ES2),		(IEN  | PTU | DIS | M2)) /* SDMMC3_DAT3 */ \
	MUX_VAL(CP(ETK_D4_ES2),		(IEN  | PTU | DIS | M2)) /* SDMMC3_DAT0 */ \
	MUX_VAL(CP(ETK_D5_ES2),		(IEN  | PTU | DIS | M2)) /* SDMMC3_DAT1 */ \
	MUX_VAL(CP(ETK_D6_ES2),		(IEN  | PTU | DIS | M2)) /* SDMMC3_DAT2 */ \
	MUX_VAL(CP(ETK_D7_ES2),		(IEN  | PTD | EN  | M4)) /* GPIO_21: IPC_SRDY */ \
	MUX_VAL(CP(ETK_D8_ES2),		(IDIS | PTD | DIS | M4)) /* GPIO_22: IPC_MRDY */ \
	MUX_VAL(CP(ETK_D9_ES2),		(IDIS | PTD | DIS | M4)) /* GPIO_23: WLAN_EN */ \
	MUX_VAL(CP(ETK_D10_ES2),	(IEN  | PTD | EN  | M4)) /* GPIO_24: WLAN_HOST_WAKEUP */ \
	MUX_VAL(CP(ETK_D11_ES2),	(IDIS | PTD | DIS | M4)) /* GPIO_25: CHG_EN_SET_N_OMAP */ \
	MUX_VAL(CP(ETK_D12_ES2),	(IDIS | PTD | DIS | M4)) /* GPIO_26: IFX_RESET_1.8V */ \
	MUX_VAL(CP(ETK_D13_ES2),	(IDIS | PTD | DIS | M4)) /* GPIO_27: IFX_PWRON_1.8V */ \
	MUX_VAL(CP(ETK_D14_ES2),	(IEN  | PTU | EN  | M4)) /* GPIO_28: CRADLE_DETECT_N */ \
	MUX_VAL(CP(ETK_D15_ES2),	(IEN  | PTU | EN  | M4)) /* GPIO_29: CRADLE_DETECT_S */ \
	/* D2D */ \
	MUX_VAL(CP(D2D_MCAD0),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD0 */ \
	MUX_VAL(CP(D2D_MCAD1),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD1 */ \
	MUX_VAL(CP(D2D_MCAD2),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD2 */ \
	MUX_VAL(CP(D2D_MCAD3),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD3 */ \
	MUX_VAL(CP(D2D_MCAD4),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD4 */ \
	MUX_VAL(CP(D2D_MCAD5),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD5 */ \
	MUX_VAL(CP(D2D_MCAD6),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD6 */ \
	MUX_VAL(CP(D2D_MCAD7),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD7 */ \
	MUX_VAL(CP(D2D_MCAD8),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD8 */ \
	MUX_VAL(CP(D2D_MCAD9),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD9 */ \
	MUX_VAL(CP(D2D_MCAD10),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD10 */ \
	MUX_VAL(CP(D2D_MCAD11),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD11 */ \
	MUX_VAL(CP(D2D_MCAD12),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD12 */ \
	MUX_VAL(CP(D2D_MCAD13),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD13 */ \
	MUX_VAL(CP(D2D_MCAD14),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD14 */ \
	MUX_VAL(CP(D2D_MCAD15),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD15 */ \
	MUX_VAL(CP(D2D_MCAD16),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD16 */ \
	MUX_VAL(CP(D2D_MCAD17),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD17 */ \
	MUX_VAL(CP(D2D_MCAD18),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD18 */ \
	MUX_VAL(CP(D2D_MCAD19),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD19 */ \
	MUX_VAL(CP(D2D_MCAD20),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD20 */ \
	MUX_VAL(CP(D2D_MCAD21),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD21 */ \
	MUX_VAL(CP(D2D_MCAD22),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD22 */ \
	MUX_VAL(CP(D2D_MCAD23),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD23 */ \
	MUX_VAL(CP(D2D_MCAD24),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD24 */ \
	MUX_VAL(CP(D2D_MCAD25),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD25 */ \
	MUX_VAL(CP(D2D_MCAD26),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD26 */ \
	MUX_VAL(CP(D2D_MCAD27),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD27 */ \
	MUX_VAL(CP(D2D_MCAD28),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD28 */ \
	MUX_VAL(CP(D2D_MCAD29),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD29 */ \
	MUX_VAL(CP(D2D_MCAD30),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD30 */ \
	MUX_VAL(CP(D2D_MCAD31),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD31 */ \
	MUX_VAL(CP(D2D_MCAD32),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD32 */ \
	MUX_VAL(CP(D2D_MCAD33),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD33 */ \
	MUX_VAL(CP(D2D_MCAD34),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD34 */ \
	MUX_VAL(CP(D2D_MCAD35),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD35 */ \
	MUX_VAL(CP(D2D_MCAD36),		(IEN  | PTD | EN  | M0)) /* D2D_MCAD36 */ \
	MUX_VAL(CP(D2D_CLK26MI),	(IDIS | PTD | DIS | M0)) /* D2D_CLK26MI */ \
	MUX_VAL(CP(D2D_NRESPWRON),	(IEN  | PTU | EN  | M0)) /* D2D_NRESPWRON */ \
	MUX_VAL(CP(D2D_NRESWARM),	(IDIS | PTU | DIS | M0)) /* D2D_NRESWARM */ \
	MUX_VAL(CP(D2D_ARM9NIRQ),	(IDIS | PTD | DIS | M0)) /* D2D_ARM9NIRQ */ \
	MUX_VAL(CP(D2D_UMA2P6FIQ),	(IDIS | PTD | DIS | M0)) /* D2D_UMA2P6FIQ */ \
	MUX_VAL(CP(D2D_SPINT),		(IEN  | PTD | DIS | M0)) /* D2D_SPINT */ \
	MUX_VAL(CP(D2D_FRINT),		(IEN  | PTD | DIS | M0)) /* D2D_FRINT */ \
	MUX_VAL(CP(D2D_DMAREQ0),	(IDIS | PTD | DIS | M0)) /* D2D_DMAREQ0 */ \
	MUX_VAL(CP(D2D_DMAREQ1),	(IDIS | PTD | DIS | M0)) /* D2D_DMAREQ1 */ \
	MUX_VAL(CP(D2D_DMAREQ2),	(IDIS | PTD | DIS | M0)) /* D2D_DMAREQ2 */ \
	MUX_VAL(CP(D2D_DMAREQ3),	(IDIS | PTD | DIS | M0)) /* D2D_DMAREQ3 */ \
	MUX_VAL(CP(D2D_N3GTRST),	(IEN  | PTD | DIS | M0)) /* D2D_N3GTRST */ \
	MUX_VAL(CP(D2D_N3GTDI),		(IEN  | PTU | EN  | M0)) /* D2D_N3GTDI */ \
	MUX_VAL(CP(D2D_N3GTDO),		(IDIS | PTD | DIS | M0)) /* D2D_N3GTDO */ \
	MUX_VAL(CP(D2D_N3GTMS),		(IEN  | PTU | EN  | M0)) /* D2D_N3GTMS */ \
	MUX_VAL(CP(D2D_N3GTCK),		(IEN  | PTD | DIS | M0)) /* D2D_N3GTCK */ \
	MUX_VAL(CP(D2D_N3GRTCK),	(IEN  | PTD | DIS | M0)) /* D2D_N3GRTCK */ \
	MUX_VAL(CP(D2D_MSTDBY),		(IEN  | PTU | EN  | M0)) /* D2D_MSTDBY */ \
	MUX_VAL(CP(D2D_SWAKEUP),	(IEN  | PTD | EN  | M0)) /* D2D_SWAKEUP */ \
	MUX_VAL(CP(D2D_IDLEREQ),	(IEN  | PTD | DIS | M0)) /* D2D_IDLEREQ */ \
	MUX_VAL(CP(D2D_IDLEACK),	(IEN  | PTU | EN  | M0)) /* D2D_IDLEACK */ \
	MUX_VAL(CP(D2D_MWRITE),		(IEN  | PTD | DIS | M0)) /* D2D_MWRITE */ \
	MUX_VAL(CP(D2D_SWRITE),		(IEN  | PTD | DIS | M0)) /* D2D_SWRITE */ \
	MUX_VAL(CP(D2D_MREAD),		(IEN  | PTD | DIS | M0)) /* D2D_MREAD */ \
	MUX_VAL(CP(D2D_SREAD),		(IEN  | PTD | DIS | M0)) /* D2D_SREAD */ \
	MUX_VAL(CP(D2D_MBUSFLAG),	(IEN  | PTD | DIS | M0)) /* D2D_MBUSFLAG */ \
	MUX_VAL(CP(D2D_SBUSFLAG),	(IEN  | PTD | DIS | M0)) /* D2D_SBUSFLAG */ \
	MUX_VAL(CP(SDRC_CKE0),		(IDIS | PTU | DIS | M0)) /* SDRC_CKE0 */ \
	MUX_VAL(CP(SDRC_CKE1),		(IDIS | PTU | DIS | M0)) /* SDRC_CKE1 */ \
	MUX_VAL(CP(GPIO127),		(IEN  | PTD | DIS | M7)) /* SAFE_MODE */ \
	MUX_VAL(CP(GPIO126),		(IDIS | PTD | DIS | M4)) /* GPIO_126: OMAP_SEND */ \
	MUX_VAL(CP(GPIO128),		(IDIS | PTD | DIS | M4)) /* GPIO_128: KEY_LED_RESET */ \
	MUX_VAL(CP(GPIO129),		(IEN  | PTD | DIS | M4)) /* GPIO_129: MODEM_AP_WAKE */

#endif
